	function [G, Z, R_ZEROS, P, Wsnew] = CA_C_POLES_S(G, Z, P, Wc, Ws, Amax, Amin)
	%
	% 	Transforms the poles of an even order analog lowpass Cauer filter of
	% 	type a with cutoff frequency Wc to have two transmission zeros at s = 
	% 	and A(0) = 0 dB.  That is, into a Cauer filter of type c.
	% 	The cutoff edge is invariant, only the stopband edge is increased to Wsnew.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar, 2008-07-15
	% 	Modified by: 	LW 2009-04-07
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs: 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if mod(length(P),2) == 1
		disp('Must be an even order filter')
		break
		stop
	end

	% Determine the true stopband edge for the type A filter of order N  can be done nicer!
	delta = (Ws-Wc)/20; Wsa = Wc;
	for n = 1:100
		W = Wsa + delta;
		A = PZ_2_ATT_S(G, Z, P, W);
		if A < Amin
			Wsa = W;
		else
			delta = delta/5;
		end
	end

	% Find the highest transmission zero pair and remove the pair
	szmax = max(abs(Z));
	Z = sort(Z);
	Z(length(Z)) = [];
	Z(length(Z)) = [];
	
	% Lowest reflection zero is
	Wrz = Wsa/(Wc*szmax);
	
	% Transform the zeros
	A = Wc^2*(szmax^2 - Wc^2)/(Wc^2 - Wrz^2);
	for n = 1:2:length(Z)
		Z(n) = sqrt(A*(Z(n)^2 + Wrz^2)/(Z(n)^2 + szmax^2));		
		Z(n+1) = conj(Z(n));
	end

	% Transform the poles
	for n = 1:2:length(P)
		P(n) = -sqrt(A*(P(n)^2 + Wrz^2)/(P(n)^2 + szmax^2));
		P(n+1) = conj(P(n));                                                              
	end

	G = real(prod(P)/prod(Z));	%  Gain constant 
	
	% The new stopband edge is
	Wsnew = imag(Wc*sqrt(A*(Wrz^2 - Wsa^2)/(szmax^2 - Wsa^2)));
	
	% The reflection zeros are
	R_ZEROS = cat(1, (Wsnew/Wc)./Z, [0],[0]);
	
